﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.Runtime.InteropServices;
using System.Drawing.Printing;          // インストールプリンタを列挙にて使用


namespace CS_sample
{
    public partial class Form1 : Form
    {
        // グローバル変数(擬似)
        static public byte[] CommEventFlag = new byte[256];  // グローバル変数の宣言

        //
        // 定数定義
        //
//        public const uint EVT_RSP_CRW_RESPONSE = 0x1;
//        public const uint EVT_RSP_CRW_READY = 0x2;
//        public const uint EVT_RSP_CRW_BUSY = 0x4;
//        public const uint EVT_RSP_CRW_CANCELED = 0x8;
//        public const uint EVT_RSP_CRW_ERR_RES_TIMEOUT = 0x100;
//        public const uint EVT_RSP_CRW_ERR_CTS_TIMEOUT = 0x200;
//        public const uint EVT_RSP_CRW_ERR_DSR = 0x400;
//        public const uint EVT_RSP_CRW_ERR_BCC_RETRY = 0x800;
//        public const uint EVT_RSP_CRW_ERR_COMM_WRITE = 0x1000;
//        public const uint EVT_RSP_CRW_ERR_COMM_READ = 0x2000;
//        public const uint EVT_RSP_CRW_ALL = 0xFFFFFFFF;

//        public const uint EVT_BIN_CRW_RESPONSE = 0x1;
//        public const uint EVT_BIN_CRW_CANCELED = 0x8;
//        public const uint EVT_BIN_CRW_ERR_RES_TIMEOUT = 0x100;
//        public const uint EVT_BIN_CRW_ERR_CTS_TIMEOUT = 0x200;
//        public const uint EVT_BIN_CRW_ERR_DSR = 0x400;
//        public const uint EVT_BIN_CRW_ERR_BCC_RETRY = 0x800;
//        public const uint EVT_BIN_CRW_ERR_COMM_WRITE = 0x1000;
//        public const uint EVT_BIN_CRW_ERR_COMM_READ = 0x2000;
//        public const uint EVT_BIN_CRW_ALL = 0xFFFFFFFF;

        public const uint EVT_PCX_RELEASE = 0x0;
        public const uint EVT_PCX_RXCHAR = 0x1;
        public const uint EVT_PCX_TXEMPTY = 0x2;
        public const uint EVT_PCX_ERR_BUFFER_OVERFLOW = 0x4;
        public const uint EVT_PCX_CTS = 0x8;
        public const uint EVT_PCX_DSR = 0x0010;
        public const uint EVT_PCX_RLSD = 0x0020;
        public const uint EVT_PCX_BREAK = 0x0040;
        public const uint EVT_PCX_RING = 0x100;
        public const uint EVT_PCX_ERR_FRAME = 0x200;
        public const uint EVT_PCX_ERR_OVERRUN = 0x400;
        public const uint EVT_PCX_ERR_PARITY = 0x800;
        public const uint EVT_PCX_ALL = 0xFFFFFFFF;

        public const uint RET_PCX_SUCCESS = 0;
        public const uint RET_PCX_EVENT_SUCCESS = 1;
        public const uint RET_PCX_ACK = 2;
        public const uint RET_PCX_NAK = 3;
        public const uint RET_PCX_RESPONSE = 10;
        public const uint RET_PCX_READY = 11;
        public const uint RET_PCX_BUSY = 12;
        public const uint RET_PCX_CANCELED = 20;
        public const uint RET_PCX_FAILURE = 30;

        public const uint RET_PCX_ERR_PARAM = 100;
        public const uint RET_PCX_ERR_PORT = 101;
        public const uint RET_PCX_ERR_RES_TIMEOUT = 110;
        public const uint RET_PCX_ERR_CTS_TIMEOUT = 111;
        public const uint RET_PCX_ERR_DSR = 112;
        // 下位バージョンとの互換性の為
        public const uint RET_PCX_ERR_DSR_TIMEOUT = 112;
        public const uint RET_PCX_ERR_BUSY_TIMEOUT = 113;
        public const uint RET_PCX_ERR_BCC_RETRY = 120;
        public const uint RET_PCX_ERR_BUFFEROVER = 130;
        public const uint RET_PCX_ERR_BUSY = 140;

        public const uint RET_PCX_ERR_COMM_WRITE = 200;
        public const uint RET_PCX_ERR_COMM_READ = 201;

        public Form1()
        {
            InitializeComponent();

            //ポート番号初期表示設定 / ポート番号初期表示設定 / 通信速度初期表示設定 
            // データ長初期表示設定 / パリティ初期表示設定

            CmbPortNo.SelectedIndex = 0;
            axPCCAx1.PortNo = 1;            //プロパティ初期化


            CmbBaudRate.SelectedIndex = 3;
            axPCCAx1.BaudRate = 9600;       //プロパティ初期化


            CmbDataBit.SelectedIndex = 1;
            axPCCAx1.DataBit = "8";           //プロパティ初期化


            CmbParity.SelectedIndex = 1;
            axPCCAx1.Parity = "E";          //プロパティ初期化


            CmbDSRCheck.SelectedIndex = 0;
            axPCCAx1.DSRCheck = true;       //プロパティ初期化


            CmbCTSCheck.SelectedIndex = 0;
            axPCCAx1.CTSCheck = true;       //プロパティ初期化


            TxtTXBufferSize.Text = "2048";
            axPCCAx1.TXBufferSize = 2048;   //プロパティ初期化


            TxtRXBufferSize.Text = "2048";
            axPCCAx1.RXBufferSize = 2048;   //プロパティ初期化


            axPCCAx1.AutoHandshake = true;

            // 送信データ初期化

            TxtSendDataWR.Text = "";
            TxtSendDataRD.Text = "";

            // 受信データ初期化

            TxtReceiveData.Text = "";

            // キャンセルフラグ設定の初期化

            CbCancelFlag.SelectedIndex = 0;
            TxtCancelTimer.Text = "2000";

            // バッファクリア　コンボボックスの初期化

            CmbComBufferClear.SelectedIndex = 0;

            // ACK待ちタイマ レスポンス待ちタイマの初期化

            ACKTimer.Text = "1000";
            ResponseTimer.Text = "3000";

            // ポーリングコマンド関連初期化

            TxtCOMSTS.Text = "";
            TxtSEN.Text = "";
            TxtERR.Text = "";
            TxtResDATA.Text = "";

            scrrRecMode.Text = "0";
            scrrBusyTimeOut.Text = "3000";

            rrRecMode.Text = "0";
            rrTimeOut.Text = "3000";

            // STX-ETX-BCC関連初期化

            sdrrResponseMode.Text = "0";
            sdrrRetryCount.Text = "3";

            sdACKCheck.Text = "0";
            sdRetryCount.Text = "3";
            sdStxEtxBcc.Text = "1";

            rdResponseMode.Text = "0";
            rdACKResponse.Text = "3000";
            rdStxEtxBcc.Text = "1";

            rdhfResponseMode.Text = "0";
            rdhfACKJudge.Text = "1";

            rdhfResReserve.Text = "";
            rdhfResResp.Text = "";
            rdhfResStat.Text = "";
            rdhfResData.Text = "";
            rdhfResDataLen.Text = "";

            // UHF関連初期化

            sbcrrReceiveResponse.Text = "0";
            sbcrrRetryCount.Text = "3";

            sbcRetryCount.Text = "3";

            rbrReceiveResponse.Text = "0";
            rbrRetryCount.Text = "3";

            // プリンタジョブ関連初期化

            SendDelayTimeTxt.Text = axPCCAx1.SendDelayTime.ToString();
            WriteFileTimeOutText.Text = axPCCAx1.WriteFileTimeOut.ToString();
            LogFlagText.Text = axPCCAx1.LogFlag.ToString();
            LogFileFolderText.Text = axPCCAx1.LogFileFolder;

            // 処理結果初期化

            RetVal.Text = "";
            RetMsg.Text = "";
            msglabel.Text = "";

            LbACKTimer.Text = "1000";
            LbResponseTimer.Text = "3000";

            LbVersion.Text = axPCCAx1.Version;

            // キャンセルフラグ設定

            LbCancelFlag.Text = axPCCAx1.CancelFlag.ToString();

            // ポート状態初期化
            int pn;
            string Claim;

            pn = axPCCAx1.PortNo;

            if (axPCCAx1.Claimed == true)
            {
                Claim = "true";
            }
            else
            {
                Claim = "false";
            }
            LbClaimed.Text = "Port" + pn.ToString() + "=" + Claim;

            // プリンターの一覧を列挙

            foreach (string printer
              in PrinterSettings.InstalledPrinters)
            {
                cboPriSet.Items.Add(printer);
            }

            cboPriSet.SelectedIndex = 0;

            // 用紙サイズの設定

            // リストボックスを初期化
            PaperList.Items.Clear();

            //PaperSizeをComboBox1に追加していく
            //PrintDocumentオブジェクトの作成
            System.Drawing.Printing.PrintDocument pd = new System.Drawing.Printing.PrintDocument();

            pd.PrinterSettings.PrinterName = cboPriSet.Text;

            foreach (System.Drawing.Printing.PaperSize ps
                            in pd.PrinterSettings.PaperSizes)
            {
                PaperList.Items.Add(ps.PaperName);
            }

            PaperList.SelectedIndex = 0;

        }

        //----------------------------------------------------------------------------------------------
        //---< その他コマンドメソッド >-----------------------------------------------------------------
        //----------------------------------------------------------------------------------------------

        private void GetPortNames_Click(object sender, EventArgs e)
        {
            PortNames.Text = axPCCAx1.GetPortNames;
        }

        private void Version_Click(object sender, EventArgs e)
        {
            LbVersion.Text = axPCCAx1.Version;
        }

        // ポート状態取得処理

        private void Claimed_Click(object sender, EventArgs e)
        {
            int pn;
            string Claim;
            
            pn = axPCCAx1.PortNo;

            if(axPCCAx1.Claimed == true)
            {
                Claim = "true";
            }
            else
            {
                Claim = "false";
            }

            LbClaimed.Text = "Port" + pn.ToString() + "=" + Claim;
        }

        // COMポート状態設定処理

        private void CmdGetCommStatus_Click(object sender, EventArgs e)
        {
            string ComSts;

            ComSts = axPCCAx1.GetCommStatus;

            LbGetCommStatus1.Text = ComSts.Substring(0, 1) + " = DSR_OFF";
            LbGetCommStatus2.Text = ComSts.Substring(1, 1) + " = CTS_OFF";
            LbGetCommStatus3.Text = ComSts.Substring(2, 1) + " = RLSD_OFF";
        }

        // 送信データ設定処理

        private void SendDataSet_Click(object sender, EventArgs e)
        {
            axPCCAx1.SendData = TxtSendDataWR.Text;
            SendDataRead_Click(null, null);
        }


        // 送信データ読み込み処理

        private void SendDataRead_Click(object sender, EventArgs e)
        {
            TxtSendDataRD.Text = axPCCAx1.SendData;
        }

        //Com Setting (SET)
        private void OpComSet_CheckedChanged(object sender, EventArgs e)
        {
            if (OpComSet.Checked == true)
            {
                axPCCAx1.PortNo = int.Parse(CmbPortNo.Text);                       // PortNo
                axPCCAx1.BaudRate = int.Parse(CmbBaudRate.Text);
                axPCCAx1.DataBit = CmbDataBit.Text;
                axPCCAx1.DSRCheck = bool.Parse(CmbDSRCheck.Text);
                axPCCAx1.CTSCheck = bool.Parse(CmbCTSCheck.Text);
                axPCCAx1.TXBufferSize = int.Parse(TxtTXBufferSize.Text);
                axPCCAx1.RXBufferSize = int.Parse(TxtRXBufferSize.Text);

                // パリティ設定

                if (CmbParity.SelectedIndex == 0)
                {
                    axPCCAx1.Parity = "N";
                }
                else if (CmbParity.SelectedIndex == 1)
                {
                    axPCCAx1.Parity = "E";
                }
                else
                {
                    axPCCAx1.Parity = "O";
                }
            }
        }

        //Com Setting (READ)
        private void OpComRead_CheckedChanged(object sender, EventArgs e)
        {
            if (OpComRead.Checked == true)
            {
                //ポート番号
                CmbPortNo.SelectedIndex = axPCCAx1.PortNo-1;   // PortNo

                //通信速度
                switch (axPCCAx1.BaudRate)
                {
                    case 1200:
                        CmbBaudRate.SelectedIndex = 0;
                        break;

                    case 2400:
                        CmbBaudRate.SelectedIndex = 1;
                        break;

                    case 4800:
                        CmbBaudRate.SelectedIndex = 2;
                        break;

                    case 9600:
                        CmbBaudRate.SelectedIndex = 3;
                        break;

                    case 19200:
                        CmbBaudRate.SelectedIndex = 4;
                        break;

                    case 38400:
                        CmbBaudRate.SelectedIndex = 5;
                        break;

                    case 57600:
                        CmbBaudRate.SelectedIndex = 6;
                        break;

                    case 115200:
                        CmbBaudRate.SelectedIndex = 7;
                        break;
                }

                //データ長
                if (axPCCAx1.DataBit == "7")
                {
                    CmbDataBit.SelectedIndex = 0;
                }
                else
                {
                    CmbDataBit.SelectedIndex = 1;
                }

                //パリティ
                if (axPCCAx1.Parity == "N")
                {
                    CmbParity.SelectedIndex = 0;
                }
                else if (axPCCAx1.Parity == "E")
                {
                    CmbParity.SelectedIndex = 1;
                }
                else
                {
                    CmbParity.SelectedIndex = 2;
                }

                //DSR
                if (axPCCAx1.DSRCheck == true)
                {
                    CmbDSRCheck.SelectedIndex = 0;
                }
                else
                {
                    CmbDSRCheck.SelectedIndex = 1;
                }

                //CTS
                if (axPCCAx1.CTSCheck == true)
                {
                    CmbCTSCheck.SelectedIndex = 0;
                }
                else
                {
                    CmbCTSCheck.SelectedIndex = 1;
                }

                //TXBuffeer
                int size;

                size = axPCCAx1.TXBufferSize;
                TxtTXBufferSize.Text = size.ToString();

                //RXBuffeer
                size = axPCCAx1.RXBufferSize;
                TxtTXBufferSize.Text = size.ToString();
            }
        }

        // ACKタイマ設定

        private void ACKTimer_TextChanged(object sender, EventArgs e)
        {
            axPCCAx1.ACKTimer = int.Parse(ACKTimer.Text);
            LbACKTimer.Text = axPCCAx1.ACKTimer.ToString();

        }

        // レスポンスタイマ設定

        private void ResponseTimer_TextChanged(object sender, EventArgs e)
        {
            axPCCAx1.ResponseTimer = int.Parse(ResponseTimer.Text);
            LbResponseTimer.Text = axPCCAx1.ResponseTimer.ToString();
        }

        // COMバッファクリア処理

        private void ComBufferClear_Click(object sender, EventArgs e)
        {
            if(CmbComBufferClear.SelectedIndex == 0){
                axPCCAx1.pcxComBufferClear(0);
            }
            else if (CmbComBufferClear.SelectedIndex == 1)
            {
                axPCCAx1.pcxComBufferClear(1);
            }
            else
            {
                axPCCAx1.pcxComBufferClear(2);
            }
        }

        //イベントマスク処理

        private void EventMask_Click(object sender, EventArgs e)
        {
            if (chkEventMask1.Checked == true)  // Set
            {
                uint evt = 0;

                if (chEventMask1.Checked == true)       // EVT_PCX_RXCHAR
                {
                    evt = evt + EVT_PCX_RXCHAR;
                }
                if (chEventMask2.Checked == true)       // EVT_CRW_TXEMPTY
                {
                    evt = evt + EVT_PCX_TXEMPTY;
                }
                if (chEventMask3.Checked == true)       // EVT_PCX_ERR_BUFFER_OVERFLOW
                {
                    evt = evt + EVT_PCX_ERR_BUFFER_OVERFLOW;
                }
                if (chEventMask4.Checked == true)       // EVT_PCX_CTS
                {
                    evt = evt + EVT_PCX_CTS;
                }
                if (chEventMask5.Checked == true)       // EVT_PCX_DSR
                {
                    evt = evt + EVT_PCX_DSR;
                }
                if (chEventMask6.Checked == true)       // EVT_PCX_RLSD
                {
                    evt = evt + EVT_PCX_RLSD;
                }
                if (chEventMask7.Checked == true)       // EVT_PCX_BREAK
                {
                    evt = evt + EVT_PCX_BREAK;
                }
                if (chEventMask8.Checked == true)       // EVT_PCX_RING
                {
                    evt = evt + EVT_PCX_RING;
                }
                if (chEventMask9.Checked == true)       // EVT_PCX_ERR_FRAME
                {
                    evt = evt + EVT_PCX_ERR_FRAME;
                }
                if (chEventMask10.Checked == true)      // EVT_PCX_ERR_OVERRUN
                {
                    evt = evt + EVT_PCX_ERR_OVERRUN;
                }
                if (chEventMask11.Checked == true)     // EVT_PCX_ERR_PARITY
                {
                    evt = evt + EVT_PCX_ERR_PARITY;
                }
                if (chEventMaskALL.Checked == true)     // EVT_PCX_ERR_ALL
                {
                    evt = 65535;    // 0xFFFF
                }

                axPCCAx1.EventMask = (int)evt;
            }
            else if (chkEventMask2.Checked == true)     //  Read
            {
                LbEventMaskRD.Text = Convert.ToString(axPCCAx1.EventMask, 16);
            }
            else if (chkEventMask3.Checked == true)     // Release
            {
                axPCCAx1.EventMask = (int)EVT_PCX_RELEASE;

                chEventMask1.Checked = false;       // EVT_PCX_RXCHAR
                chEventMask2.Checked = false;       // EVT_CRW_TXEMPTY
                chEventMask3.Checked = false;       // EVT_PCX_ERR_BUFFER_OVERFLOW
                chEventMask4.Checked = false;       // EVT_PCX_CTS
                chEventMask5.Checked = false;       // EVT_PCX_DSR
                chEventMask6.Checked = false;       // EVT_PCX_RLSD
                chEventMask7.Checked = false;       // EVT_PCX_BREAK
                chEventMask8.Checked = false;       // EVT_PCX_RING
                chEventMask9.Checked = false;       // EVT_PCX_ERR_FRAME
                chEventMask10.Checked = false;      // EVT_PCX_ERR_OVERRUN
                chEventMask11.Checked = false;      // EVT_PCX_ERR_PARITY
                chEventMaskALL.Checked = false;     // EVT_PCX_ERR_ALL
            }
        }

        // プリンター変更処理

        private void cboPriSet_SelectedIndexChanged(object sender, EventArgs e)
        {
            // 用紙サイズの設定

            // リストボックスを初期化
            PaperList.Items.Clear();

            //PaperSizeをComboBox1に追加していく
            //PrintDocumentオブジェクトの作成
            System.Drawing.Printing.PrintDocument p = new System.Drawing.Printing.PrintDocument();

            p.PrinterSettings.PrinterName = cboPriSet.Text;

            foreach (System.Drawing.Printing.PaperSize ps
                            in p.PrinterSettings.PaperSizes)
            {
                PaperList.Items.Add(ps.PaperName);
            }

            PaperList.SelectedIndex = 0;
        }

        // プリンタージョブクリア処理

        private void PrintJobClear_Click(object sender, EventArgs e)
        {
            axPCCAx1.PrinterDeviceName = LbPrinterDeviceName.Text;
            axPCCAx1.pcxPrintJobClear();
        }

        private PrintDialog printDialog1 = new PrintDialog();
        // プリントプロパティの起動

        private void cmdPriProperty_Click(object sender, EventArgs e)
        {
            //WindowsXpスタイルのダイアログを表示する（WindowsXp以降のOSの場合）

            this.printDialog1.UseEXDialog = true;

            //印刷対象となるPrintDocumentオブジェクトを指定する（ここでは新規に作成）

            System.Drawing.Printing.PrintDocument docToPrint = new System.Drawing.Printing.PrintDocument();

            //PrinterSettingsを取得するために使用するPrintDocumentを設定する

            this.printDialog1.Document = docToPrint;

            //プリンタ設定を指定する（プリンタごとの印刷開始ページや用紙サイズなどを設定する）

            System.Drawing.Printing.PrinterSettings mySetting = new System.Drawing.Printing.PrinterSettings();

            //ダイアログボックスで変更するプリンタ設定

            this.printDialog1.PrinterSettings = mySetting;
            mySetting.PrinterName = cboPriSet.Text;

            //コモンダイアログボックスを表示する
            this.printDialog1.ShowDialog();
        }


        private void cmdPrinterDeviceName_Click(object sender, EventArgs e)
        {
            LbPrinterDeviceName.Text = cboPriSet.Text;
        }

        // LOG環境情報設定

        private void SetCommand_Click(object sender, EventArgs e)
        {
            axPCCAx1.SendDelayTime = int.Parse(SendDelayTimeTxt.Text); 
            axPCCAx1.WriteFileTimeOut = int.Parse(WriteFileTimeOutText.Text);
            axPCCAx1.LogFlag = int.Parse(LogFlagText.Text);
            axPCCAx1.LogFileFolder = LogFileFolderText.Text;
        }

        // LOG環境情報読込
        private void ReadCommand_Click(object sender, EventArgs e)
        {
            SendDelayTimeTxt.Text = axPCCAx1.SendDelayTime.ToString();
            WriteFileTimeOutText.Text = axPCCAx1.WriteFileTimeOut.ToString();
            LogFlagText.Text = axPCCAx1.LogFlag.ToString();
            LogFileFolderText.Text = axPCCAx1.LogFileFolder;
        }

        // DTR信号線制御
        private void ChkDTRLineControl_CheckedChanged(object sender, EventArgs e)
        {
            if (ChkDTRLineControl.Checked == true)
            {
                axPCCAx1.DTRLineControl = true;
            }
            else
            {
                axPCCAx1.DTRLineControl = false;
            }
        }

        // RTS信号線制御
        private void ChkRTSLineControl_CheckedChanged(object sender, EventArgs e)
        {
            if (ChkRTSLineControl.Checked == true)
            {
                axPCCAx1.RTSLineControl = true;
            }
            else
            {
                axPCCAx1.RTSLineControl = false;
            }
        }

        // BREAK信号線制御
        private void ChkBreakControl_CheckedChanged(object sender, EventArgs e)
        {
            if (ChkBreakControl.Checked == true)
            {
                axPCCAx1.BreakControl = true;
            }
            else
            {
                axPCCAx1.BreakControl = false;
            }
        }

        // AUTO Handshake
        private void CheckHandshake_CheckedChanged(object sender, EventArgs e)
        {
            if (CheckHandshake.Checked == true)
            {
                axPCCAx1.AutoHandshake = true;
            }
            else
            {
                axPCCAx1.AutoHandshake = false;
            }
        }

        // キャンセルフラグ設定

        private void CancelFlag_Click(object sender, EventArgs e)
        {
            if(OpCancelFlag1.Checked == true){
                axPCCAx1.CancelFlag = bool.Parse(CbCancelFlag.Text);
                LbCancelFlag.Text = axPCCAx1.CancelFlag.ToString();
            }else if( OpCancelFlag2.Checked == true){
                LbCancelFlag.Text = axPCCAx1.CancelFlag.ToString();
                for( int i = 0 ; i < CbCancelFlag.Items.Count; i++){
                    if( CbCancelFlag.Text == axPCCAx1.CancelFlag.ToString()){
                        CbCancelFlag.SelectedIndex = i;
                        break;
                    }
                }
            }
        }

        //----------------------------------------------------------------------------------------------
        //---< ポート制御 >-----------------------------------------------------------------------------
        //----------------------------------------------------------------------------------------------

        // ポートオープン関数処理

        // (pcxOpenPort)
        private void OpenPort_Click(object sender, EventArgs e)
        {
            int ret = 0;

            RefreshMsg();   // 処理結果 TextBox クリア

            // ポートオープン関数実行

            ret = axPCCAx1.pcxOpenPort();

            // 処理結果の表示
            RetVal.Text = ret.ToString();
            ErrMsg((uint)ret, "pcxOpenPort");
        }

        // ポートクローズ関数処理

        private void ClosePort_Click(object sender, EventArgs e)
        {
            int ret = 0;

            RefreshMsg();   // 処理結果 TextBox クリア

            // ポートクローズ実行

            ret = axPCCAx1.pcxClosePort();

            // 処理結果を表示
            RetVal.Text = ret.ToString();
            ErrMsg((uint)ret, "pcxClosePort");
        }

        //----------------------------------------------------------------------------------------------
        //---< ポーリングコマンド >---------------------------------------------------------------------
        //----------------------------------------------------------------------------------------------

        // コマンド送受信関数処理

        // (pcxSendCommandRR)
        private void SendCommandRR_Click(object sender, EventArgs e)
        {
            int ret = 0;
            int iRecMode;
            int lBusyTimeOut;

            RefreshMsg();   // 処理結果 TextBox クリア

            // 入力/参照項目(テキストボックス）の初期化

            TxtCOMSTS.Clear();
            TxtCOMSTS.Refresh();
            TxtSEN.Clear();
            TxtSEN.Refresh();
            TxtERR.Clear();
            TxtERR.Refresh();
            TxtResDATA.Clear();
            TxtResDATA.Refresh();

            // ポート番号等の情報取得

            iRecMode = short.Parse(scrrRecMode.Text);               // RecMode
            lBusyTimeOut = int.Parse(scrrBusyTimeOut.Text);         // BusyTimeOut

            if (ChkCancelTimerF.Checked == true)
            {
                SetCancelTimer();
            }
            //コマンド送受信関数実行

            ret = axPCCAx1.pcxSendCommandRR(
                            iRecMode,
                            lBusyTimeOut
                            );

            if (ChkCancelTimerR.Checked == true)
            {
                SetCancelTimer();
            }

            if ((ret == RET_PCX_RESPONSE) || (ret == RET_PCX_READY) || (ret == RET_PCX_BUSY))   // 結果が正常な場合

            {
                // 実行結果の表示
                TxtCOMSTS.Text = axPCCAx1.PollCmdComSts;
                TxtSEN.Text = axPCCAx1.PollCmdSen;
                TxtERR.Text = axPCCAx1.PollCmdErr;
                TxtResDATA.Text = axPCCAx1.PollCmdResData;
            }

            // 処理結果の表示
            RetVal.Text = ret.ToString();
            ErrMsg((uint)ret, "pcxSendCommandRR");
        }

        // コマンド送信関数処理

        private void SendCommand_Click(object sender, EventArgs e)
        {
            int ret = 0;

            RefreshMsg();   // 処理結果 TextBox クリア

            if (ChkCancelTimerF.Checked == true)
            {
                SetCancelTimer();
            }
            // コマンド送信関数実行

            ret = axPCCAx1.pcxSendCommand();

            if (ChkCancelTimerR.Checked == true)
            {
                SetCancelTimer();
            }

            // 処理結果設定

            RetVal.Text = ret.ToString();
            ErrMsg((uint)ret, "pcxSendCommand");

            // レスポンス受信関数呼出指定の場合

            if (OpSendCommand2.Checked == true)
            {
                ReceiveResponse_Click(null, null);   // レスポンス受信関数呼出
            }
        }

        // レスポンス受信関数処理

        private void ReceiveResponse_Click(object sender, EventArgs e)
        {
            int ret = 0;
            int iRecMode;
            int  lBusyTimeOut;

            RefreshMsg();   // 処理結果 TextBox クリア

            TxtCOMSTS.Clear();
            TxtCOMSTS.Refresh();
            TxtSEN.Clear();
            TxtSEN.Refresh();
            TxtERR.Clear();
            TxtERR.Refresh();
            TxtResDATA.Clear();
            TxtResDATA.Refresh();

            // ポート番号等の情報取得

            iRecMode = int.Parse(rrRecMode.Text);               // RecMode
            lBusyTimeOut = int.Parse(rrTimeOut.Text);   // BusyTimeOut

            if (ChkCancelTimerF.Checked == true)
            {
                SetCancelTimer();
            }

            // レスポンス受信関数実行

            ret = axPCCAx1.pcxReceiveResponse(
                            iRecMode,
                            lBusyTimeOut
            );

            if (ChkCancelTimerR.Checked == true)
            {
                SetCancelTimer();
            }

            if ((ret == RET_PCX_RESPONSE) || (ret == RET_PCX_READY) || (ret == RET_PCX_BUSY))   // 結果が正常な場合
            {
                // 実行結果の表示
                TxtCOMSTS.Text = axPCCAx1.PollCmdComSts;
                TxtSEN.Text = axPCCAx1.PollCmdSen;
                TxtERR.Text = axPCCAx1.PollCmdErr;
                TxtResDATA.Text = axPCCAx1.PollCmdResData;
            }

            // 処理結果表示
            RetVal.Text = ret.ToString();
            ErrMsg((uint)ret, "pcxReceiveResponse");
        }

        //----------------------------------------------------------------------------------------------
        //---< 電文データ コマンド >--------------------------------------------------------------------
        //----------------------------------------------------------------------------------------------

        //電文データ送受信メソッド
        private void SendDataRR_Click(object sender, EventArgs e)
        {
            int ret = 0;
            int lResponseMode;
            int lRetryCount;

            RefreshMsg();   // 処理結果 TextBox クリア
            TxtReceiveData.Clear();
            TxtReceiveDataLen.Clear();
            TxtReceiveData.Refresh();
            TxtReceiveDataLen.Refresh();

            lResponseMode = int.Parse(sdrrResponseMode.Text);   // レスポンスモード設定

            lRetryCount = int.Parse(sdrrRetryCount.Text);       // リトライカウント設定


            if (ChkCancelTimerF.Checked == true)
            {
                SetCancelTimer();
            }
            // 電文データ送受信関数処理

            ret = axPCCAx1.pcxSendDataBCCRR(lResponseMode, lRetryCount);

            if (ChkCancelTimerR.Checked == true)
            {
                SetCancelTimer();
            }

            if (ret == RET_PCX_SUCCESS)
            {
                TxtReceiveData.Text = axPCCAx1.ReceiveData;         // 受信ﾃﾞｰﾀ設定

                TxtReceiveDataLen.Text = axPCCAx1.ReceiveDataLen.ToString();   // 受信ﾃﾞｰﾀ長設定

            }

            toolTip1.SetToolTip(TxtReceiveData, TxtReceiveData.Text); // ヘルプ


            RetVal.Text = ret.ToString(); // 処理結果設定

            ErrMsg((uint)ret, "pcxSendDataBCCRR");
        }

        //電文データ送信メソッド
        private void SendData_Click(object sender, EventArgs e)
        {
            int ret = 0;
            int lACKCheck;
            int lRetryCount;
            int lStxEtxBCC;

            RefreshMsg();   // 処理結果 TextBox クリア

            lACKCheck = int.Parse(sdACKCheck.Text);         // ACKチェック設定

            lRetryCount = int.Parse(sdRetryCount.Text);     // リトライカウント設定

            lStxEtxBCC = int.Parse(sdStxEtxBcc.Text);       // データ構成タイプ(STX-BCC)設定


            if (ChkCancelTimerF.Checked == true)
            {
                SetCancelTimer();
            }
            // 電文データ送受信関数処理

            ret = axPCCAx1.pcxSendData(lACKCheck,lRetryCount,lStxEtxBCC);

            if (ChkCancelTimerF.Checked == true)
            {
                SetCancelTimer();
            }

            RetVal.Text = ret.ToString(); // 処理結果設定

            ErrMsg((uint)ret, "pcxSendData");
        }

        //電文データ受信メソッド
        private void ReceiveData_Click(object sender, EventArgs e)
        {
            int ret = 0;
            int lResponseMode;
            int lACKCheck;
            int lStxEtxBCC;

            RefreshMsg();   // 処理結果 TextBox クリア
            TxtReceiveData.Clear();
            TxtReceiveDataLen.Clear();
            TxtReceiveData.Refresh();
            TxtReceiveDataLen.Refresh();

            lResponseMode = int.Parse(rdResponseMode.Text);   // レスポンスモード設定

            lACKCheck = int.Parse(rdACKResponse.Text);       // リトライカウント設定

            lStxEtxBCC = int.Parse(rdStxEtxBcc.Text);       // リトライカウント設定


            if (ChkCancelTimerF.Checked == true)
            {
                SetCancelTimer();
            }
            // 電文データ送受信関数処理

            ret = axPCCAx1.pcxReceiveData(lResponseMode,lACKCheck,lStxEtxBCC);

            if (ChkCancelTimerR.Checked == true)
            {
                SetCancelTimer();
            }

            if (ret == RET_PCX_SUCCESS)
            {
                TxtReceiveData.Text = axPCCAx1.ReceiveData;         // 受信ﾃﾞｰﾀ設定

                TxtReceiveDataLen.Text = axPCCAx1.ReceiveDataLen.ToString();   // 受信ﾃﾞｰﾀ長設定

            }

            toolTip1.SetToolTip(TxtReceiveData, TxtReceiveData.Text); // ヘルプ


            RetVal.Text = ret.ToString(); // 処理結果設定

            ErrMsg((uint)ret, "pcxReceiveData");
        }

        //HF帯RFID電文データ受信メソッド
        private void ReceiveDataHF_Click(object sender, EventArgs e)
        {
            int ret = 0;

            int lResponseMode;
            int iACKJudge;

            RefreshMsg();   // 処理結果 TextBox クリア

            // Response情報クリア
            rdhfResReserve.Clear();
            rdhfResReserve.Refresh();
            rdhfResReserve.BackColor = Color.White;

            rdhfResResp.Clear();
            rdhfResResp.Refresh();
            rdhfResResp.BackColor = Color.White;

            rdhfResStat.Clear();
            rdhfResStat.Refresh();
            rdhfResStat.BackColor = Color.White;

            rdhfResData.Clear();
            rdhfResData.Refresh();
            rdhfResData.BackColor = Color.White;

            rdhfResDataLen.Clear();
            rdhfResDataLen.Refresh();
            rdhfResDataLen.BackColor = Color.White;

            iACKJudge = int.Parse(rdhfACKJudge.Text);             // ACKJudge設定

            lResponseMode = int.Parse(rdhfResponseMode.Text);     // レスポンスモード設定


            if (ChkCancelTimerF.Checked == true)
            {
                SetCancelTimer();
            }
            // HF帯RFID電文ﾃﾞｰﾀ受信関数
            ret = axPCCAx1.pcxReceiveDataHF(lResponseMode, iACKJudge);

            if (ChkCancelTimerR.Checked == true)
            {
                SetCancelTimer();
            }

            if (ret == 0) // 正常終了の場合

            {
                rdhfResReserve.Text = axPCCAx1.HFReceiveReserve;            // ReserveF設定

                rdhfResResp.Text = axPCCAx1.HFReceiveResp;                  // RespF設定

                rdhfResStat.Text = axPCCAx1.HFReceiveStat;                  // ResStatF設定

                rdhfResData.Text = axPCCAx1.HFReceiveData;                  // ResStatF設定

                rdhfResDataLen.Text = axPCCAx1.HFReceiveDataLen.ToString(); // ResStatF設定


                rdhfResReserve.BackColor = Color.LightGreen;    // 背景色を緑に設定

                rdhfResResp.BackColor = Color.LightGreen;       // 
                rdhfResStat.BackColor = Color.LightGreen;       // 

                toolTip1.SetToolTip(rdhfResData, rdhfResData.Text);   // ヒント表示
            }

            // 再表示
            rdhfResReserve.Refresh();
            rdhfResResp.Refresh();
            rdhfResStat.Refresh();
            rdhfResData.Refresh();
            rdhfResDataLen.Refresh();

            // 処理結果
            RetVal.Text = ret.ToString();
            ErrMsg((uint)ret, "pcxReceiveDataHF");
        }

        //HF帯RFID電文データ送受信メソッド
        private void SendDataHFRR_Click(object sender, EventArgs e)
        {
            int ret = 0;

            int lResponseMode;
            int iACKJudge;

            RefreshMsg();   // 処理結果 TextBox クリア

            // Response情報クリア
            rdhfResReserve.Clear();
            rdhfResReserve.Refresh();
            rdhfResReserve.BackColor = Color.White;

            rdhfResResp.Clear();
            rdhfResResp.Refresh();
            rdhfResResp.BackColor = Color.White;

            rdhfResStat.Clear();
            rdhfResStat.Refresh();
            rdhfResStat.BackColor = Color.White;

            rdhfResData.Clear();
            rdhfResData.Refresh();
            rdhfResData.BackColor = Color.White;

            rdhfResDataLen.Clear();
            rdhfResDataLen.Refresh();
            rdhfResDataLen.BackColor = Color.White;

            iACKJudge = int.Parse(rdhfACKJudge.Text);             // ACKJudge設定

            lResponseMode = int.Parse(rdhfResponseMode.Text);     // レスポンスモード設定


            // HF帯RFID電文ﾃﾞｰﾀ受信関数
            ret = axPCCAx1.pcxSendDataHFRR(lResponseMode, iACKJudge);

            if (ret == 0) // 正常終了の場合

            {
                rdhfResReserve.Text = axPCCAx1.HFReceiveReserve;            // ReserveF設定

                rdhfResResp.Text = axPCCAx1.HFReceiveResp;                  // RespF設定

                rdhfResStat.Text = axPCCAx1.HFReceiveStat;                  // ResStatF設定

                rdhfResData.Text = axPCCAx1.HFReceiveData;                  // ResStatF設定

                rdhfResDataLen.Text = axPCCAx1.HFReceiveDataLen.ToString(); // ResStatF設定


                rdhfResReserve.BackColor = Color.LightGreen;    // 背景色を緑に設定

                rdhfResResp.BackColor = Color.LightGreen;       // 
                rdhfResStat.BackColor = Color.LightGreen;       // 

                toolTip1.SetToolTip(rdhfResData, rdhfResData.Text);   // ヒント表示
            }

            // 再表示
            rdhfResReserve.Refresh();
            rdhfResResp.Refresh();
            rdhfResStat.Refresh();
            rdhfResData.Refresh();
            rdhfResDataLen.Refresh();

            // 処理結果
            RetVal.Text = ret.ToString();
            ErrMsg((uint)ret, "pcxSendDataHFRR");
        }

        //----------------------------------------------------------------------------------------------
        //---< バイナリコマンド(UHF) >------------------------------------------------------------------
        //----------------------------------------------------------------------------------------------
        // UHF帯RFIDコマンド送受信メソッド
        private void SendBinaryCommandRR_Click(object sender, EventArgs e)
        {
            int ret = 0;
            int lRetryCount;
            int lResponseMode;

            RefreshMsg();

            TxtReceiveData.Clear();         // 受信ﾃﾞｰﾀﾃｷｽﾄﾎﾞｯｸｽ初期化

            TxtReceiveData.Refresh();       // 
            TxtReceiveDataLen.Clear();      // 受信ﾃﾞｰﾀﾚﾝｸﾞｽ初期化

            TxtReceiveDataLen.Refresh();    // 

            lResponseMode = int.Parse(sbcrrReceiveResponse.Text);   // ResponseMode設定

            lRetryCount = int.Parse(sbcrrRetryCount.Text);          // RetryCount設定


            if (ChkCancelTimerF.Checked == true)
            {
                SetCancelTimer();
            }
            // UHF帯RFIDｺﾏﾝﾄﾞ送受信関数呼出
            ret = axPCCAx1.pcxSendBinaryCommandRR(lResponseMode, lRetryCount);

            if (ChkCancelTimerR.Checked == true)
            {
                SetCancelTimer();
            }

            TxtReceiveData.Text = axPCCAx1.ReceiveData;

            toolTip1.SetToolTip(TxtReceiveData, TxtReceiveData.Text);  // ヒント設定


            TxtReceiveDataLen.Text = axPCCAx1.ReceiveDataLen.ToString(); // 受信ﾃﾞｰﾀ長設定

            RetVal.Text = ret.ToString(); // 処理結果設定

            ErrMsg((uint)ret, "pcxSendBinaryCommandRR");
        }

        // UHF帯RFIDコマンド送信メソッド
        private void SendBinaryCommand_Click(object sender, EventArgs e)
        {
            int ret = 0;
            int lRetryCount;

            RefreshMsg();   // 処理結果 TextBox クリア

            lRetryCount = short.Parse(sbcRetryCount.Text);  // RetryCount設定


            if (ChkCancelTimerF.Checked == true)
            {
                SetCancelTimer();
            }
            // UHF帯RFIDコマンド送信関数呼び出し

            ret = axPCCAx1.pcxSendBinaryCommand( lRetryCount );

            if (ChkCancelTimerR.Checked == true)
            {
                SetCancelTimer();
            }

            // 処理結果設定

            RetVal.Text = ret.ToString();
            ErrMsg((uint)ret, "pcxSendBinaryCommand");
        }

        // UHF帯RFIDコマンド受信メソッド
        private void ReceiveBinaryReport_Click(object sender, EventArgs e)
        {
            int ret = 0;
            int lRetryCount;
            int lResponseMode;

            RefreshMsg();   // 処理結果 TextBox クリア

            TxtReceiveData.Clear();         // 受信ﾃﾞｰﾀﾃｷｽﾄﾎﾞｯｸｽ初期化

            TxtReceiveData.Refresh();       // 
            TxtReceiveDataLen.Clear();      // 受信ﾃﾞｰﾀﾚﾝｸﾞｽ初期化

            TxtReceiveDataLen.Refresh();    // 

            lResponseMode = int.Parse(rbrReceiveResponse.Text);     // DSRCheck設定

            lRetryCount = int.Parse(rbrRetryCount.Text); // RetryCount設定


            if (ChkCancelTimerF.Checked == true)
            {
                SetCancelTimer();
            }
            // UHF帯RFIDコマンド受信関数呼出
            ret = axPCCAx1.pcxReceiveBinaryReport(lResponseMode,lRetryCount);

            if (ChkCancelTimerR.Checked == true)
            {
                SetCancelTimer();
            }

            TxtReceiveData.Text = axPCCAx1.ReceiveData;

            toolTip1.SetToolTip(TxtReceiveData, TxtReceiveData.Text);   // ヒントテキスト設定


            TxtReceiveDataLen.Text = axPCCAx1.ReceiveDataLen.ToString();   // 受信データ長設定


            RetVal.Text = ret.ToString();                   // 処理結果設定

            ErrMsg((uint)ret, "pcxReceiveBinaryReport");
        }

        //----------------------------------------------------------------------------------------------
        //---< バイナリデータ >-------------------------------------------------------------------------
        //----------------------------------------------------------------------------------------------
        private void SendBinaryData_Click(object sender, EventArgs e)
        {
            int ret = 0;

            RefreshMsg();   // 処理結果 TextBox クリア

            if (ChkCancelTimerF.Checked == true)
            {
                SetCancelTimer();
            }
            // バイナリデータ送信関数ＱＲ
            ret = axPCCAx1.pcxSendBinaryData();

            if (ChkCancelTimerR.Checked == true)
            {
                SetCancelTimer();
            }

            RetVal.Text = ret.ToString();   // 処理結果設定

            ErrMsg((uint)ret, "pcxSendBinaryData");
        }

        private void ReceiveBinaryData_Click(object sender, EventArgs e)
        {
            int ret = 0;

            RefreshMsg();   // 処理結果 TextBox クリア

            TxtReceiveData.Clear();         // 受信ﾃﾞｰﾀﾃｷｽﾄﾎﾞｯｸｽ初期化

            TxtReceiveData.Refresh();       // 
            TxtReceiveDataLen.Clear();      // 受信ﾃﾞｰﾀﾚﾝｸﾞｽ初期化

            TxtReceiveDataLen.Refresh();    // 

            if (ChkCancelTimerF.Checked == true)
            {
                SetCancelTimer();
            }
            // バイナリデータ受信関数
            ret = axPCCAx1.pcxReceiveBinaryData();

            if (ChkCancelTimerR.Checked == true)
            {
                SetCancelTimer();
            }

            TxtReceiveData.Text = axPCCAx1.ReceiveData;

            // ヒントメッセージ
            toolTip1.SetToolTip(TxtReceiveData, TxtReceiveData.Text);

            // 受信データ長設定

            TxtReceiveDataLen.Text = axPCCAx1.ReceiveDataLen.ToString();

            // 処理結果
            RetVal.Text = ret.ToString();
            ErrMsg((uint)ret, "crwReceiveBinaryData");
        }

        //----------------------------------------------------------------------------------------------
        //---< 共通処理 >-------------------------------------------------------------------------------
        //----------------------------------------------------------------------------------------------

        // タイマ設定

        private void SetCancelTimer()
        {
            Canceltimer.Interval = int.Parse(TxtCancelTimer.Text);
            Canceltimer.Enabled = true;
        }

        // 処理結果メッセージの初期化

        private void RefreshMsg()
        {
            RetVal.Clear();
            RetVal.BackColor = Color.White;
            RetVal.Refresh();

            RetMsg.Clear();
            RetMsg.BackColor = Color.White;
            RetMsg.Refresh();
        }

        // エラーメッセージ表示処理

        private void ErrMsg(uint err, string ms)
        {
            msglabel.Text = ms;
            switch (err)
            {
                case RET_PCX_SUCCESS:
                    RetVal.BackColor = Color.Green;
                    RetMsg.BackColor = Color.Green;
                    RetMsg.Text = "OK";
                    break;

                case RET_PCX_EVENT_SUCCESS:
                    RetVal.BackColor = Color.Aquamarine;
                    RetMsg.BackColor = Color.Aquamarine;
                    RetMsg.Text = "EVENT SUCCESS";
                    break;

                case RET_PCX_ACK:
                    RetVal.BackColor = Color.Green;
                    RetMsg.BackColor = Color.Green;
                    RetMsg.Text = "ACK";
                    break;

                case RET_PCX_NAK:
                    RetVal.BackColor = Color.Red;
                    RetMsg.BackColor = Color.Red;
                    RetMsg.Text = "NAK";
                    break;


                case RET_PCX_RESPONSE:
                    RetVal.BackColor = Color.Green;
                    RetMsg.BackColor = Color.Green;
                    RetMsg.Text = "RESPONSE";
                    break;


                case RET_PCX_READY:
                    RetVal.BackColor = Color.Green;
                    RetMsg.BackColor = Color.Green;
                    RetMsg.Text = "READY";
                    break;

                case RET_PCX_BUSY:
                    RetVal.BackColor = Color.Pink;
                    RetMsg.BackColor = Color.Pink;
                    RetMsg.Text = "BUSY";
                    break;

                case RET_PCX_CANCELED:
                    RetVal.BackColor = Color.Yellow;
                    RetMsg.BackColor = Color.Yellow;
                    RetMsg.Text = "CANCELD";
                    break;

                case RET_PCX_FAILURE:
                    RetVal.BackColor = Color.Red;
                    RetMsg.BackColor = Color.Red;
                    RetMsg.Text = "FAILURE";
                    break;


                case RET_PCX_ERR_PARAM:
                    RetVal.BackColor = Color.Red;
                    RetMsg.BackColor = Color.Red;
                    RetMsg.Text = "PARAM ERR";
                    break;

                case RET_PCX_ERR_PORT:
                    RetVal.BackColor = Color.Red;
                    RetMsg.BackColor = Color.Red;
                    RetMsg.Text = "PORT ERR";
                    break;

                case RET_PCX_ERR_RES_TIMEOUT:
                    RetVal.BackColor = Color.Red;
                    RetMsg.BackColor = Color.Red;
                    RetMsg.Text = "RES TIMEOUT";
                    break;

                case RET_PCX_ERR_CTS_TIMEOUT:
                    RetVal.BackColor = Color.Red;
                    RetMsg.BackColor = Color.Red;
                    RetMsg.Text = "CTS TIMEOUT";
                    break;

                case RET_PCX_ERR_DSR_TIMEOUT:
                    RetVal.BackColor = Color.Red;
                    RetMsg.BackColor = Color.Red;
                    RetMsg.Text = "DSR ERR";
                    break;

                case RET_PCX_ERR_BCC_RETRY:
                    RetVal.BackColor = Color.Red;
                    RetMsg.BackColor = Color.Red;
                    RetMsg.Text = "BCC ERR";
                    break;

                case RET_PCX_ERR_BUFFEROVER:
                    RetVal.BackColor = Color.Red;
                    RetMsg.BackColor = Color.Red;
                    RetMsg.Text = "バッファオーバー";
                    break;

                case RET_PCX_ERR_BUSY:
                    RetVal.BackColor = Color.Red;
                    RetMsg.BackColor = Color.Red;
                    RetMsg.Text = "非同期処理実行中！";
                    break;

                case RET_PCX_ERR_COMM_WRITE:
                    RetVal.BackColor = Color.Red;
                    RetMsg.BackColor = Color.Red;
                    RetMsg.Text = "COMM WRITE ERR";
                    break;

                case RET_PCX_ERR_COMM_READ:
                    RetVal.BackColor = Color.Red;
                    RetMsg.BackColor = Color.Red;
                    RetMsg.Text = "COMM READ ERR";
                    break;

                default:
                    RetVal.BackColor = Color.Red;
                    RetMsg.BackColor = Color.Red;
                    RetMsg.Text = "OTHER ERR";
                    break;
            }
        }

        //----------------------------------------------------------------------------------------
        //---< イベント処理 >---------------------------------------------------------------------
        //----------------------------------------------------------------------------------------

        //COMイベント処理

        private void axPCCAx1_pcxCommEvent(object sender, AxPCCAXLib._DPCCAxEvents_pcxCommEventEvent e)
        {
            switch(e.lEvent){
                case (int)EVT_PCX_RXCHAR:
                    if( OpEVT_RXCHAR_Return1.Checked == true ){
                        MessageBox. Show("EVT_PCX_RXCHAR", "pcxCommEvent");

                    }
                    else if (OpEVT_RXCHAR_Return2.Checked == true)
                    {
                        tabControl1.SelectedTab = tabPage2;
                        ReceiveData_Click(null, null);

                    }
                    else if (OpEVT_RXCHAR_Return3.Checked == true)
                    {
                        tabControl1.SelectedTab = tabPage2;
                        ReceiveDataHF_Click(null, null);

                    }
                    else if (OpEVT_RXCHAR_Return4.Checked == true)
                    {
                        tabControl1.SelectedTab = tabPage3;
                        ReceiveBinaryReport_Click(null, null);

                    }
                    else if (OpEVT_RXCHAR_Return5.Checked == true)
                    {
                        tabControl1.SelectedTab = tabPage4;
                        ReceiveBinaryData_Click(null, null);
                    }
                    break;

                case (int)EVT_PCX_TXEMPTY:
                     MessageBox.Show("EVT_PCX_TXEMPTY", "pcxCommEvent");
                     break;

                case (int)EVT_PCX_ERR_BUFFER_OVERFLOW:
                     MessageBox.Show("EVT_PCX_ERR_BUFFER_OVERFLOW", "pcxCommEvent");
                     break;

                case (int)EVT_PCX_CTS:
                     MessageBox.Show("EVT_PCX_CTS", "pcxCommEvent");
                     break;

                case (int)EVT_PCX_DSR:
                     ClosePort_Click(null,null);
                     MessageBox.Show("EVT_PCX_DSR", "pcxCommEvent");
                     break;

                case (int)EVT_PCX_RLSD:
                     MessageBox.Show("EVT_PCX_RLSD", "pcxCommEvent");
                     break;

                case (int)EVT_PCX_BREAK:
                      ClosePort_Click(null, null);
                      MessageBox.Show("EVT_PCX_BREAK", "pcxCommEvent");
                      break;

                case (int)EVT_PCX_RING:
                      MessageBox.Show("EVT_PCX_RING", "pcxCommEvent");
                      break;

                case (int)EVT_PCX_ERR_FRAME:
                      MessageBox.Show("EVT_PCX_ERR_FRAME", "pcxCommEvent");
                      break;

                case (int)EVT_PCX_ERR_OVERRUN:
                      MessageBox.Show("EVT_PCX_ERR_OVERRUN", "pcxCommEvent");
                      break;

                case (int)EVT_PCX_ERR_PARITY:
                      MessageBox.Show("EVT_PCX_ERR_PARITY", "pcxCommEvent");
                      break;
            }
        }

        //コマンドレスポンスイベント処理

        private void axPCCAx1_pcxReceiveResponseEvent(object sender, AxPCCAXLib._DPCCAxEvents_pcxReceiveResponseEventEvent e)
        {
             // 実行結果の表示
             TxtCOMSTS.Text = axPCCAx1.PollCmdComSts;
             TxtSEN.Text = axPCCAx1.PollCmdSen;
             TxtERR.Text = axPCCAx1.PollCmdErr;
             TxtResDATA.Text = axPCCAx1.PollCmdResData;

            // 処理結果表示
            RetVal.Text = e.lResponse.ToString();
            ErrMsg((uint)e.lResponse, "pcxReceiveResponseEvent");
        }

        //HFデータ受信イベント処理

        private void axPCCAx1_pcxReceiveDataHFEvent(object sender, AxPCCAXLib._DPCCAxEvents_pcxReceiveDataHFEventEvent e)
        {
            RefreshMsg();   // 処理結果 TextBox クリア

            // Response情報クリア
            rdhfResReserve.Clear();
            rdhfResReserve.Refresh();
            rdhfResReserve.BackColor = Color.White;

            rdhfResResp.Clear();
            rdhfResResp.Refresh();
            rdhfResResp.BackColor = Color.White;

            rdhfResStat.Clear();
            rdhfResStat.Refresh();
            rdhfResStat.BackColor = Color.White;

            rdhfResData.Clear();
            rdhfResData.Refresh();
            rdhfResData.BackColor = Color.White;

            rdhfResDataLen.Clear();
            rdhfResDataLen.Refresh();
            rdhfResDataLen.BackColor = Color.White;


            rdhfResReserve.Text = axPCCAx1.HFReceiveReserve;            // ReserveF設定

            rdhfResResp.Text = axPCCAx1.HFReceiveResp;                  // RespF設定

            rdhfResStat.Text = axPCCAx1.HFReceiveStat;                  // ResStatF設定

            rdhfResData.Text = axPCCAx1.HFReceiveData;                  // ResStatF設定

            rdhfResDataLen.Text = axPCCAx1.HFReceiveDataLen.ToString(); // ResStatF設定


            rdhfResReserve.BackColor = Color.LightGreen;    // 背景色を緑に設定

            rdhfResResp.BackColor = Color.LightGreen;       // 
            rdhfResStat.BackColor = Color.LightGreen;       // 

            toolTip1.SetToolTip(rdhfResData, rdhfResData.Text);   // ヒント表示

            // 再表示
            rdhfResReserve.Refresh();
            rdhfResResp.Refresh();
            rdhfResStat.Refresh();
            rdhfResData.Refresh();
            rdhfResDataLen.Refresh();

            // 処理結果
            RetVal.Text = e.lResponse.ToString();
            ErrMsg((uint)e.lResponse, "pcxReceiveDataHFEvent");
        }

        //STX-BCCレスポンスイベント処理

        private void axPCCAx1_pcxReceiveDataBCCEvent(object sender, AxPCCAXLib._DPCCAxEvents_pcxReceiveDataBCCEventEvent e)
        {
            RefreshMsg();   // 処理結果 TextBox クリア
            TxtReceiveData.Clear();
            TxtReceiveDataLen.Clear();
            TxtReceiveData.Refresh();
            TxtReceiveDataLen.Refresh();

            TxtReceiveData.Text = axPCCAx1.ReceiveData;         // 受信ﾃﾞｰﾀ設定

            TxtReceiveDataLen.Text = axPCCAx1.ReceiveDataLen.ToString();   // 受信ﾃﾞｰﾀ長設定


            toolTip1.SetToolTip(TxtReceiveData, TxtReceiveData.Text); // ヘルプ


            RetVal.Text = e.lResponse.ToString(); // 処理結果設定

            ErrMsg((uint)e.lResponse, "pcxReceiveDataEvent");
        }

        //バイナリ(UHF)データ受信イベント処理

        private void axPCCAx1_pcxReceiveBinaryReportEvent(object sender, AxPCCAXLib._DPCCAxEvents_pcxReceiveBinaryReportEventEvent e)
        {
            RefreshMsg();   // 処理結果 TextBox クリア

            TxtReceiveData.Clear();         // 受信ﾃﾞｰﾀﾃｷｽﾄﾎﾞｯｸｽ初期化

            TxtReceiveData.Refresh();       // 
            TxtReceiveDataLen.Clear();      // 受信ﾃﾞｰﾀﾚﾝｸﾞｽ初期化

            TxtReceiveDataLen.Refresh();    // 

            TxtReceiveData.Text = axPCCAx1.ReceiveData;

            toolTip1.SetToolTip(TxtReceiveData, TxtReceiveData.Text);   // ヒントテキスト設定


            TxtReceiveDataLen.Text = axPCCAx1.ReceiveDataLen.ToString();   // 受信データ長設定


            RetVal.Text = e.lBinaryReport.ToString();                   // 処理結果設定

            ErrMsg((uint)e.lBinaryReport, "pcxReceiveBinaryReportEvent");
        }

        //----------------------------------------------------------------------------------------
        //---< タイマ処理 >-----------------------------------------------------------------------
        //----------------------------------------------------------------------------------------
        private void Canceltimer_Tick(object sender, EventArgs e)
        {
            Canceltimer.Enabled = false;
            OpCancelFlag1.Checked = true;
            CbCancelFlag.SelectedIndex = 0;
            CancelFlag_Click(null , null);
        }
    }
}